// OpenLine4.h: interface for the COpenLine4 class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OPENLINE4_H__E58BA498_0B43_4C65_A0F0_214DBCC0D24B__INCLUDED_)
#define AFX_OPENLINE4_H__E58BA498_0B43_4C65_A0F0_214DBCC0D24B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "api/vpbapi.h"

class COpenLine4  
{
public:
	bool IsPlaying();
	bool IsRecording();
	bool ShutDownVPB();
	int		SetCallback(void (WINAPI *event_callback)(VPB_EVENT *e, void *context), void *context);
	int		StopPlay();
	int		StopRecord();
	bool	Call(CString sNumber);
	bool	PlayFile(CString sFileName);
	bool	RecordFile(CString sFileName);
	bool	GetEventDescAsync(CString &str);
	bool	GetEventAsync(VPB_EVENT &e);
	int		SwitchHook();
	unsigned int GetChannelNum();
	bool	GetHookState();
	int		GetLastError();
	
	int		InitVPB(unsigned int CardNum, unsigned int ChannelNum);

	COpenLine4();
	virtual ~COpenLine4();

private:
	bool m_IsBusy;
	bool	m_IsPlaying;
	bool	m_IsRecording;
	int		m_Handle;
	unsigned int m_ChannelNum;
	unsigned int m_CardNum;
	bool	m_HookState;
	int		m_LastErrorCode;
	void	(WINAPI *m_EventCallback)(VPB_EVENT *e, void *context);
	static void WINAPI event_callback(VPB_EVENT *e, void *context);
};

#endif // !defined(AFX_OPENLINE4_H__E58BA498_0B43_4C65_A0F0_214DBCC0D24B__INCLUDED_)
